﻿using System;
using System.Text;
using System.Runtime.InteropServices;

namespace GTDevmonSample
{
    class GDev
    {
        private IntPtr m_hMapFile;
        private UInt32 m_ulMapPointer;
        private UInt64 m_ulMapPointer64;
        private Int16 m_sGotNo;

        [DllImport("GDevlib_GT27.dll")]
        private extern unsafe static UInt32 GDev_OpenMapping(IntPtr* phMapFile, Int16 sGotNo);

        [DllImport("GDevlib_GT27.dll")]
        private extern static void GDev_CloseUnMapping(IntPtr hMapFile, UInt32 ulMapPointer);

        [DllImport("GDevlib_GT27.dll")]
        private extern unsafe static Int32 GDev_Read(UInt32 ulMapPointer, Int16 sDevNameID, Int32 lDevNum, UInt16* pusDataTable, Int32 lDataSize);

        [DllImport("GDevlib_GT27.dll")]
        private extern unsafe static Int32 GDev_Write(UInt32 ulMapPointer, Int16 sDevNameID, Int32 lDevNum, UInt16* pusDataTable, Int32 lDataSize);


        [DllImport("GDevlib64_GT27.dll", EntryPoint="GDev_OpenMapping")]
        private extern unsafe static UInt64 GDev_OpenMapping64(IntPtr* phMapFile, Int16 sGotNo);

        [DllImport("GDevlib64_GT27.dll", EntryPoint="GDev_CloseUnMapping")]
        private extern static void GDev_CloseUnMapping64(IntPtr hMapFile, UInt64 ulMapPointer);

        [DllImport("GDevlib64_GT27.dll", EntryPoint="GDev_Read")]
        private extern unsafe static Int32 GDev_Read64(UInt64 ulMapPointer, Int16 sDevNameID, Int32 lDevNum, IntPtr* pusDataTable, Int32 lDataSize);

        [DllImport("GDevlib64_GT27.dll", EntryPoint="GDev_Write")]
        private extern unsafe static Int32 GDev_Write64(UInt64 ulMapPointer, Int16 sDevNameID, Int32 lDevNum, IntPtr* pusDataTable, Int32 lDataSize);


        public enum DeviceName
        {
            GB,GD,GS
        }

        ~GDev()
        {
            Close();
        }

        public unsafe bool Open(Int16 sGotNo)
        {
            if (m_hMapFile == IntPtr.Zero)
            {
                IntPtr hMapFile;
                if (IntPtr.Size == 8)
                {
                    m_ulMapPointer64 = GDev_OpenMapping64(&hMapFile, sGotNo);

                    if (m_ulMapPointer64 != 0)
                    {
                        m_hMapFile = hMapFile;
                        m_sGotNo = sGotNo;

                        return true;
                    }
                }
                else
                {
                    m_ulMapPointer = GDev_OpenMapping(&hMapFile, sGotNo);

                    if (m_ulMapPointer != 0)
                    {
                        m_hMapFile = hMapFile;
                        m_sGotNo = sGotNo;

                        return true;
                    }
                }
            }

            return false;
        }

        public bool IsOpen()
        {
            return (m_hMapFile != IntPtr.Zero);
        }

        public void Close()
        {
            if (m_hMapFile != IntPtr.Zero)
            {
                if (IntPtr.Size == 8)
                {
                    GDev_CloseUnMapping64(m_hMapFile, m_ulMapPointer64);
                }
                else
                {
                    GDev_CloseUnMapping(m_hMapFile, m_ulMapPointer);
                }

                m_hMapFile = IntPtr.Zero;
                m_sGotNo = 0;
            }
        }

        private Int16 GetDevNameID(DeviceName eDevName)
        {
            switch (eDevName)
            {
                case DeviceName.GB:
                    return 0;
                case DeviceName.GD:
                    return 1;
                case DeviceName.GS:
                    return 2;
            }

            return -1;
        }

        private bool GetFlag(UInt16 sVal, int iBit)
        {
            int iMask = 1 << iBit;
            return ((sVal & iMask) != 0);
        }

        private UInt16 SetFlag(UInt16 sVal, int iBit, bool bFlag)
        {
            int iMask = (1 << iBit);
            if (bFlag)
            {
                return (UInt16)(sVal | iMask);
            }
            else
            {
                return (UInt16)(sVal & ~iMask);
            }
        }

        public unsafe UInt16 Read(DeviceName eDevName, Int32 lDevNum)
        {
            if (m_hMapFile != IntPtr.Zero)
            {
                UInt16 usValue = 0;
                Int16 sDevNameID = GetDevNameID(eDevName);
                bool usRes = false;

                if (IntPtr.Size == 8)
                {
                    if (GDev_Read64(m_ulMapPointer64, sDevNameID, lDevNum, (IntPtr*)&usValue, 1) == 0)
                    {
                        usRes = true;
                    }
                }
                else
                {
                    if (GDev_Read(m_ulMapPointer, sDevNameID, lDevNum, &usValue, 1) == 0)
                    {
                        usRes = true;
                    }
                }

                if (usRes == true)
                {
                    if (eDevName == DeviceName.GB)
                    {
                        if(GetFlag(usValue, lDevNum % 16))
                        {
                            return 1;
                        } 
                        else
                        {
                            return 0;
                        }
                    }
                    else
                    {
                        return usValue;
                    }
                }
            }

            return 0;
        }

        public unsafe bool Write(DeviceName eDevName, Int32 lDevNum, UInt16 usValue)
        {
            bool usRes = false;
            
            if (m_hMapFile != IntPtr.Zero)
            {
                Int16 sDevNameID = GetDevNameID(eDevName);

                if (eDevName == DeviceName.GB)
                {
                    UInt16 usTmpValue = 0;

                    if (IntPtr.Size == 8)
                    {
                        if (GDev_Read64(m_ulMapPointer64, sDevNameID, lDevNum, (IntPtr*)&usTmpValue, 1) == 0)
                        {
                            usRes = true;
                        }
                    }
                    else
                    {
                        if (GDev_Read(m_ulMapPointer, sDevNameID, lDevNum, &usTmpValue, 1) == 0)
                        {
                            usRes = true;
                        }
                    }

                    if (usRes == true)
                    {
                        usValue = SetFlag(usTmpValue, lDevNum % 16, (usValue != 0));
                    }
                }

                if (IntPtr.Size == 8)
                {
                    if (GDev_Write64(m_ulMapPointer64, sDevNameID, lDevNum, (IntPtr*)&usValue, 1) == 0)
                    {
                        return true;
                    }
                }
                else
                {
                    if (GDev_Write(m_ulMapPointer, sDevNameID, lDevNum, &usValue, 1) == 0)
                    {
                        return true;
                    }
                }
            }

            return false;
        }

        override public string ToString()
        {
            return string.Format("GT SoftGOT2000");
        }
    }
}
